#version 140
#extension GL_EXT_gpu_shader4 : enable
//Mandelbrot ThingyMod01.fsh by BigWings
//https://www.shadertoy.com/view/3tlcW8

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.
#define iTime u_Elapsed* 0.666
//#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;


vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}




// "Mandelbrot thingy" 
// by Martijn Steinrucken aka BigWings/CountFrolic - 2020
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// 
//
// Since Shane posted a mandelbrot experiment he had lying around here:
// https://www.shadertoy.com/view/ttscWn
//
// I figured I'd do the same. This is a super quick and dirty mandelbrot 
// port from this tutorial: https://youtu.be/zmWkhlocBRY

vec4 _Area;
float _Angle=0., _Color=0., _Repeat, _Speed, _Symmetry, _Time;
#define T iTime
#define MAX_ITER 100.
#define AA 3

vec2 rot(vec2 p, vec2 pivot, float a) {
    float s = sin(a);
    float c = cos(a);

    p -= pivot;
    p = vec2(p.x*c-p.y*s, p.x*s+p.y*c);
    p += pivot;

    return p;
}

vec3 Gradient(vec2 p) {
    // IQ palette idea
    
    vec3 a = vec3(0.5, 0.5, 0.5);
    vec3 b = vec3(0.5, 0.5, 0.5);
    vec3 c = vec3(1.0, 1.0, 0.5);
    vec3 d = vec3(0.8, 0.9, 0.3);
    
	return a + b*cos(6.2832*(c*p.x+d));
}

vec4 Mandelbrot(vec2 uv) {
    
    vec2 c = _Area.xy + uv*_Area.zw;
    c = rot(c, _Area.xy, _Angle);

    float r = 20.; // escape radius
    float r2 = r * r;

    vec2 z=vec2(0), zPrevious;
    float iter;
    for (iter = 0.; iter < MAX_ITER; iter++) {
        zPrevious = rot(z, vec2(0), T);
        z = vec2(z.x*z.x-z.y*z.y, 2.*z.x*z.y) + c;

        if (dot(z, zPrevious) > r2) break;
    }
    if (iter > MAX_ITER) return vec4(0);

    float dist = length(z); // distance from origin
    float fracIter = (dist - r) / (r2 - r); // linear interpolation
    fracIter = log2( log(dist) / log(r) ); // double exponential interpolation

    float m = sqrt(iter / MAX_ITER);
    vec4 col = sin(vec4(.3, .45, .65, 1)*m*20.)*.5+.5; // procedural colors
    col = Gradient(vec2(m*_Repeat + T*_Speed, _Color+T*.03)).rgbb;

    float angle = atan(z.x, z.y); // -pi and pi
    //if(i.uv.x>.5)
    col *= smoothstep(3., 0., fracIter);

    col *= 1.+sin(angle * 2.+T*4.)*.2;
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    _Time = iTime;
    _Repeat = 5.;
    _Speed = -.2;
    
    float scale = 5.581448e-4;
    _Area = vec4(.3177064,.03223879,scale,scale);
    
    vec3 col = vec3(0);
    for(int x=0;x<AA; x++) {
        for(int y=0;y<AA; y++) {
            vec2 offs = vec2(x, y)/float(AA);
            
            vec2 uv = (gl_FragCoord.xy+offs)/iResolution.xy;

            col += Mandelbrot(uv).rgb;
        }}
    col /= float(AA*AA);
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}